#!/bin/sh
# version : 2.0

freeze() {
    echo "Freezing from install-update-from-epc" >> /tmp/update.log
    while true; do
        sleep 1
    done
}

copy_from_epc() {
  sshpass -p 'sscl' ssh -o StrictHostKeyChecking=no sscl@192.168.10.10 'scp -o StrictHostKeyChecking=no /tmp/nonlinear-c15-update.tar root@192.168.10.11:/update'
}

stop_playground() {
  sshpass -p 'sscl' ssh -o StrictHostKeyChecking=no sscl@192.168.10.10 'systemctl stop playground'
}

stop_bbbb() {
    systemctl stop bbbb
}

t2s() {
   /usr/bin/text2soled multitext "$1" "$2" "$3" "$4"
}

pretty() {
    echo "$*"
    BOLED_LINE_1="$1"
    BOLED_LINE_2="$2"
    SOLED_LINE_2="$1"
    SOLED_LINE_3="$2"

    t2s "${BOLED_LINE_1}@b3c" "${BOLED_LINE_2}@b4c" "${SOLED_LINE_2}@s1c" "${SOLED_LINE_3}@s2c"
}

unpack_update() {
    pretty "Copying C15 update..." "DO NOT SWITCH OFF!"
    if rm -rf /update \
        && mkdir -p /update \
        && copy_from_epc \
        && cd /update;
    then
      pretty "Unpacking C15 update..." "DO NOT SWITCH OFF!"
      if tar xf nonlinear-c15-update.tar; then
        return 0
      fi
    fi
    pretty "Update Media Error!" "Please retry"
    sleep 2
    return 1
}

check_preconditions() {
    if ! ls -l /update/BBB/ | grep bbb_update_1811a.sh \
        && ! ls -l /update/BBB/ | grep bbb_update_1905a.sh \
        && ! ls -l /update/BBB/ | grep playground-RELEASE-2019-05-1.5-706569a \
        &&   ls -l /update | grep at-least-version-22-42.stamp; then
            return 0
    fi

    rm -rf /update/*
    pretty "C15 update rejected!" "Update is no longer supported."
    sleep 5
    return 1
}

run_update() {
    chmod +x /update/run.sh
    /bin/sh /update/run.sh
    freeze
}

main() {
    echo "install-update-from-epc.sh" >> /tmp/update.log
    stop_bbbb
    stop_playground
    unpack_update && check_preconditions && run_update
    return 0
}

main
