#!/bin/sh

# version :     1.0
#
# ----------- EPC7i5 Fixes  ---------
# - add x-run fixing commandline parameters to grub

# Procedure: will be copied to the ePC und /tmp after update and executed

set -x

epc_fix() {
  mkdir -p /tmp/sda2
  mount /dev/sda2 /tmp/sda2
  mount /dev/sda1 /tmp/sda2/boot
  fix_errors=0

  if ! cat /proc/cmdline | grep "isolcpus=domain,managed_irq,2-3" > /dev/null; then
    arch-chroot /tmp/sda2 /bin/bash -c "sed -i 's/GRUB_CMDLINE_LINUX_DEFAULT.*$/GRUB_CMDLINE_LINUX_DEFAULT=\"rw quiet net.ifnames=0 biosdevname=0 ip=192.168.10.10:::::eth0:none mitigations=off isolcpus=domain,managed_irq,2-3 kthread_cpus=0-1 irqaffinity=0-1 rcu_nocbs=0-1 rcu_nocb_poll nohz_full=2-3 intel_pstate=no_hwp intel_pstate=passive nmi_watchdog=0 nosoftlockup noht nowatchdog threadirqs i915.enable_rc6=0 i915.enable_de=0 i915.disable_power_well=0 processor.max_cstate=0 processor_idle.max_cstate=0 intel_idle.max_cstate=0\"/g' /etc/default/grub"
    arch-chroot /tmp/sda2 /bin/bash -c "grub-mkconfig -o /boot/grub/grub.cfg" \
      || printf "E48 ePC7i5 fix: setting Kernel Params failed" >> /tmp/fix_error.log && ((fix_errors++))
  fi

  umount /tmp/sda2/boot
  umount /tmp/sda2
  if [ $fix_errors -gt 0 ]; then
       return 48
  fi
  return 0
}


main() {
    epc_fix
    return $?
}

main
